import pickle
import numpy as np
import pandas as pd
from pil import image
from skimage.metrics import structural_similarity
import imageio

def compare_plots(ai_output, reference_output):  
    # load the images  
    image1 = image.open(ai_output)  
    image2 = image.open(reference_output)  
    
    # define the new size (width, height)  
    new_size = (800, 600)  
    
    # resize the images  
    resized_image1 = image1.resize(new_size, image.resampling.lanczos)  
    resized_image2 = image2.resize(new_size, image.resampling.lanczos)  
    
    # save the resized images  
    resized_image1.save("resized_plot1.png")  
    resized_image2.save("resized_plot2.png")  

    image1 = imageio.imread("resized_plot1.png", mode='l')  
    image2 = imageio.imread("resized_plot2.png", mode='l')  
    
    ssim = structural_similarity(image1, image2, data_range=1)  
    
    return ssim

def compare_dataframes(df_origin, df_1, df_2):
    if not (df_1.index.equals(df_2.index)):
        return false

    if all(col in df_origin.columns for col in df_1.columns):
        if set(df_1.columns) != set(df_2.columns):
            return false
        for col in df_1.columns:
            df_2_col = df_2[col] if col in df_2.columns else df_2[df_1.columns[df_1.columns == col][0]]
            if df_1[col].dtype.kind in 'ifc' and df_2_col.dtype.kind in 'ifc':
                if not np.allclose(df_1[col], df_2_col, equal_nan=true):
                    return false
            elif not df_1[col].equals(df_2_col):
                return false
    else:
        for col in df_1.columns:
            if col not in df_origin.columns:
                found_match = false
                for df_2_col in df_2.columns:
                    if df_1[col].dtype.kind in 'ifc' and df_2[df_2_col].dtype.kind in 'ifc':
                        if np.allclose(df_1[col], df_2[df_2_col], equal_nan=true):
                            found_match = true
                            break
                    elif df_1[col].dtype == df_2[df_2_col].dtype:
                        if df_1[col].equals(df_2[df_2_col]):
                            found_match = true
                            break
                if not found_match:
                    return false

    return true

# replace <ai_res> and <ref_res> with the actual ai and reference outputs
machine_result = "pred_result/pie_chart.png"

reference_result = "ref_result/pie_chart.png"
  
# call the compare_plots function with both outputs
try:
    result = compare_plots(machine_result, reference_result)
except:
    result = false

print(result)

# replace <ai_res> and <ref_res> with the actual ai and reference outputs
try:
    with open("pred_result/potential_laptops.pkl", "rb") as fp:
        machine_result = pickle.load(fp)
except:
    machine_result = none

with open("ref_result/potential_laptops.pkl", "rb") as fr:
    reference_result = pickle.load(fr)

df_origin = pd.read_csv("YOUR_DIR/new_data_llama/laptops_price.csv")

# call the satisfies_user_requirements function with both outputs
try:
    result = compare_dataframes(df_origin, machine_result, reference_result)
except:
    result = false

print(result)
